<?php
/* --------------------------------------------------------------
  VpeRepository.php 2021-11-03
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2021 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Deprecated\Vpe\App\Data;

use Gambio\Core\Configuration\Services\ConfigurationService;

/**
 * Class VpeRepository
 * @package    Gambio\Admin\Modules\Deprecated\Vpe\App\Data
 * @deprecated will be removed with the release of 4.7!
 */
class VpeRepository
{
    private const DISPLAY_VPE_CONFIGURATION_KEY = 'gm_configuration/DISPLAY_VPE_PRODUCT_OPTIONS';
    
    /**
     * @var ConfigurationService
     */
    private $configurationService;
    /**
     * @var VpeReader
     */
    private $reader;
    /**
     * @var VpeWriter
     */
    private $writer;
    
    
    /**
     * @param ConfigurationService $configurationService
     * @param VpeReader            $reader
     * @param VpeWriter            $writer
     */
    public function __construct(
        ConfigurationService $configurationService,
        VpeReader $reader,
        VpeWriter $writer
    ) {
        $this->configurationService = $configurationService;
        $this->reader               = $reader;
        $this->writer               = $writer;
    }
    
    
    /**
     * @return bool
     */
    public function vpeDisplayConfigurationValue(): bool
    {
        $configuration = $this->configurationService->find(self::DISPLAY_VPE_CONFIGURATION_KEY);
        
        return $configuration !== null && $configuration->value() !== 'false';
    }
    
    
    /**
     * @param string $languageCode
     *
     * @return array
     */
    public function availableVpe(string $languageCode): array
    {
        return $this->reader->availableVpe($languageCode);
    }
    
    
    /**
     * @param int $productId
     *
     * @return array
     */
    public function productVpeData(int $productId): array
    {
        return $this->reader->productVpeData($productId);
    }
    
    
    /**
     * @param int   $productOptionId
     * @param int   $vpeId
     * @param float $vpeValue
     */
    public function storeVpeData(int $productOptionId, int $vpeId, float $vpeValue): void
    {
        $this->writer->store($productOptionId, $vpeId, $vpeValue);
    }
}